//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace CLRUnleashed
{
	class A
	{
		public virtual void Message() 
		{
			Console.WriteLine("To jest wiadomo z A");
		}
	}
	sealed class B: A
	{
		public override void Message() 
		{
			Console.WriteLine("To jest wiadomo z B");
		}
	}
	class C: A
	{
		// methodhideoverride.cs(21,15): warning CS0114: 'CLRUnleashed.C.Message()'
		// hides inherited member 'CLRUnleashed.A.Message()'. To make the current
		// member override that implementation, add the override keyword. Otherwise
		// add the new keyword.
		// public void Message() 
		public new void Message() 
		{
			Console.WriteLine("This is a message from C");
		}
	}
	// Usu znaki komentarza poniej, aby uzyska komunikat o bdzie
	// MethodHideOverride.cs(31): 'CLRUnleashed.D' : cannot inherit from 
	// sealed class 'CLRUnleashed.B'
	// class D: B
	// {
	// 	public override void Message() 
	// 	{
	// 		Console.WriteLine("To jest wiadomo z D");
	// 	}
	// }

	/// <summary>
	/// Podsumowanie dla MethodHideOverride.
	/// </summary>
	class MethodHideOverride
	{
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			// Podstawowe dziedziczenie
			Console.WriteLine("---- metoda A");
			A a = new A();
			a.Message();
			Console.WriteLine("---- metoda B");
			B b = new B();
			b.Message();
			Console.WriteLine("---- Rzutowanie B do metody A");
			((A)b).Message();
			
			// Hide a method
			Console.WriteLine("---- metoda C");
			C c = new C();
			c.Message();
			Console.WriteLine("---- Rzutowanie C do metody A");
			((A)c).Message();
		}
	}
}
